﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Controls;
using Microsoft.Maps.MapControl;

namespace MapModes
{
    public class CologneMapMode : AerialMode
    {
        private Range<double> validLatitudeRange;
        private Range<double> validLongitudeRange;

        public CologneMapMode()
        {
            // The latitude value range (From = bottom most latitude, To = top most latitude)
            validLatitudeRange = new Range<double>(50.93, 50.95);
            // The longitude value range (From = left most longitude, To = right most longitude)
            validLongitudeRange = new Range<double>(6.94, 6.98);
        }

        // Restricts the map view.
        protected override Range<double> GetZoomRange(Location center)
        {
            // The allowable zoom levels - 14 to 21.
            return new Range<double>(14, 21);
        }

        
        // This method is called when the map view changes on Keyboard 
        // and Navigation Bar events.
        public override bool ConstrainView(Location center, ref double zoomLevel, ref double heading, ref double pitch)
        {
            bool isChanged = base.ConstrainView(center, ref zoomLevel, ref heading, ref pitch);

            double newLatitude = center.Latitude;
            double newLongitude = center.Longitude;

            // If the map view is outside the valid longitude range,
            // move the map back within range.
            if (center.Longitude > validLongitudeRange.To)
            {
                newLongitude = validLongitudeRange.To;
            }
            else if (center.Longitude < validLongitudeRange.From)
            {
                newLongitude = validLongitudeRange.From;
            }

            // If the map view is outside the valid latitude range,
            // move the map back within range.
            if (center.Latitude > validLatitudeRange.To)
            {
                newLatitude = validLatitudeRange.To;
            }
            else if (center.Latitude < validLatitudeRange.From)
            {
                newLatitude = validLatitudeRange.From;
            }

            // The new map view location.
            if (newLatitude != center.Latitude || newLongitude != center.Longitude)
            {
                center.Latitude = newLatitude;
                center.Longitude = newLongitude;
                isChanged = true;
            }

            // The new zoom level.
            Range<double> range = GetZoomRange(center);
            if (zoomLevel > range.To)
            {
                zoomLevel = range.To;
                isChanged = true;
            }
            else if (zoomLevel < range.From)
            {
                zoomLevel = range.From;
                isChanged = true;
            }

            return isChanged;
        }
    }
}
